package org.bm.p2p.navigablep2p;

import java.util.BitSet;
import java.util.Random;

/**
 * 
 * @author duanshuiliu
 * еĽڵ
 *
 */
public class Node {
	static final int BUCKETS = 6; // Ͱ(ֵ32ıҲ168)
	static final int K = 1; // ÿͰԪظ

	private BitSet nodePosition; //ڵλ

	private Node inNeighbors[][]; // ھб
	private Node outNeighbors[][]; // ھӽڵб[ĳԪֵǾǸýڵͱڵľ]
	
	// ΪdistanceĽڵneighborھӽڵб
	public void setInNeighbor(Node neighbor, int distance) {
		int i;
		// ͰûѸýڵͰ
		for (i = 0; i < K; i++) {
			if (inNeighbors[distance][i] == null) {
				inNeighbors[distance][i] = neighbor;
				break;
			}
		}
		//Ͱ(Ͱ½ڵ)ѡһ̭̭㷨ʹãο Kadmelia
		if (i == K) {
			Random random = new Random();
			int chosedIdx = random.nextInt(K+1);
			if (chosedIdx < K)
				inNeighbors[distance][chosedIdx] = neighbor;
		}
	}
	// þΪdistanceھ
	public Node getInNeighbor(int distance) {
		int i;
		//Ͱѡȡһھ
		for (i = 0; i < K; i++) {
			if (inNeighbors[distance][i] == null) {
				break;
			}
		}
		if (i>0) {
			Random random = new Random();
			return inNeighbors[distance][random.nextInt(i)];
		}
		return null;
	}
	
	
	// ΪdistanceĽڵneighborھӽڵб
	public void setOutNeighbor(Node neighbor, int distance) {
		int i;
		// ͰûѸýڵͰ
		for (i = 0; i < K; i++) {
			if (outNeighbors[distance][i] == null) {
				outNeighbors[distance][i] = neighbor;
				break;
			}
		}
		//ͰͰѡһ̭̭㷨ʹãο Kadmelia
		if (i == K) {
			Random random = new Random();
			int chosedIdx = random.nextInt(K+1);
			if (chosedIdx < K)
				outNeighbors[distance][chosedIdx] = neighbor;
		}
	}
	// þΪdistanceĳھ
	public Node getOutNeighbor(int distance) {
		int i;
		//Ͱѡȡһھ
		for (i = 0; i < K; i++) {
			if (outNeighbors[distance][i] == null) {
				break;
			}
		}
		if (i>0) {
			Random random = new Random();
			return outNeighbors[distance][random.nextInt(i)];
		}
		return null;
	}

	// ΪdistanceĽڵneighborھӽڵб
	public boolean setOutNeighborByIdx(Node neighbor, int distance, int idx) {
		if (idx >= K ) return false;
		outNeighbors[distance][idx] = neighbor;
		return true;
	}
	// þΪdistanceĳھ
	public Node getOutNeighborByIdx(int distance, int idx) {
		if (idx >= K) return null;
		return outNeighbors[distance][idx];
	}

	//ʼڵ㣬λΪֵ
	public Node() {
		super();
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandom();
		this.outNeighbors = new Node[BUCKETS][K];
		this.inNeighbors = new Node[BUCKETS][K];
		System.out.println(nodePosition);
	}

	//ʼڵ㣬λúͽڵnodeľdistanceѡȡ
	public Node(Node node, int distance) {
		super();
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandomByDistance(node, distance);
		this.outNeighbors = new Node[BUCKETS][K];
		this.inNeighbors = new Node[BUCKETS][K];
		System.out.println(nodePosition);
	}

	public Node(BitSet nodePosition) {
		super();
		this.nodePosition = nodePosition;
		this.outNeighbors = new Node[BUCKETS][K];
		this.inNeighbors = new Node[BUCKETS][K];
	}

	// ɽڵλ
	public void setNodePositionRandom() {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS<32)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		for (i =0 ; i < ((BUCKETS<32)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS<32)?BUCKETS:32); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}
	
	//ɺͽڵnodeľΪdistanceĽڵλ
	public void setNodePositionRandomByDistance(Node node, int distance) {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS==16)||(BUCKETS==8)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		assert(distance<BUCKETS&&distance>=0); // λ[0, BUCKETS-1]
		for (i =0 ; i < ((BUCKETS==16)||(BUCKETS==8)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS==8)?8:(BUCKETS==16?16:32)); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
		// Ӧλλ
		i = Node.BUCKETS-1;
		while (i>distance) {
			nodePosition.set(i, node.getNodePosition().get(i));
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}

	public BitSet getNodePosition() {
		return nodePosition;
	}

	public void setNodePosition(BitSet nodePosition) {
		this.nodePosition = nodePosition;
	}
	
	// ͽڵnode֮ľ
	public int getDistanceFrom(Node node) {
		int ret = 0;
		// cloneڵ㣨ΪڼĹУxorڵľҪı䣩
		BitSet twinPosition = (BitSet) this.nodePosition.clone();
		twinPosition.xor(node.getNodePosition());
		ret = twinPosition.length() - 1;
		return ret;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((nodePosition == null) ? 0 : nodePosition.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Node other = (Node) obj;
		if (nodePosition == null) {
			if (other.nodePosition != null)
				return false;
		} else if (!nodePosition.equals(other.nodePosition))
			return false;
		return true;
	}
	
	
}
